<?php
    // Hier kommt der Code zur Überprüfung der Admin-Berechtigungen
    include('db_connection.php'); // Datei für die Datenbankverbindung

    // Hier könnten zusätzliche Funktionen oder Sicherheitsüberprüfungen implementiert werden

    // Beispiel: Alle Benutzer abrufen
    $userQuery = "SELECT * FROM users";
    $userResult = mysqli_query($connection, $userQuery);

    // Beispiel: Alle Wallets abrufen
    $walletQuery = "SELECT * FROM wallets";
    $walletResult = mysqli_query($connection, $walletQuery);

    // Beispiel: Hauptwallet abrufen
    $mainWalletQuery = "SELECT * FROM main_wallet";
    $mainWalletResult = mysqli_query($connection, $mainWalletQuery);

    // Wenn das Formular zum Hinzufügen eines Benutzers gesendet wurde
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_user'])) {
        $newEmail = mysqli_real_escape_string($connection, $_POST['email']);
        $newPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);

        // Benutzer hinzufügen
        $addUserQuery = "INSERT INTO users (email, password) VALUES ('$newEmail', '$newPassword')";
        mysqli_query($connection, $addUserQuery);
    }

    // Wenn das Formular zum Löschen eines Benutzers gesendet wurde
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_user'])) {
        $userIdToDelete = mysqli_real_escape_string($connection, $_POST['user_id']);

        // Benutzer löschen
        $deleteUserQuery = "DELETE FROM users WHERE user_id = '$userIdToDelete'";
        mysqli_query($connection, $deleteUserQuery);

        // Lösche auch zugehörige Wallets
        $deleteWalletsQuery = "DELETE FROM wallets WHERE user_id = '$userIdToDelete'";
        mysqli_query($connection, $deleteWalletsQuery);
    }

    // Wenn das Formular zum Bearbeiten des Hauptwallets gesendet wurde
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_main_wallet'])) {
        $newMainWalletBalance = mysqli_real_escape_string($connection, $_POST['new_main_wallet_balance']);

        // Hauptwallet aktualisieren
        $updateMainWalletQuery = "UPDATE main_wallet SET balance = '$newMainWalletBalance' WHERE wallet_id = 1";
        mysqli_query($connection, $updateMainWalletQuery);
    }

    // Wenn das Formular zum Ändern des Wallet-Guthabens gesendet wurde
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_user_wallet'])) {
        $userIdToEdit = mysqli_real_escape_string($connection, $_POST['user_id']);
        $newWalletBalance = mysqli_real_escape_string($connection, $_POST['new_wallet_balance']);

        // Wallet-Guthaben für den Benutzer aktualisieren
        $updateUserWalletQuery = "UPDATE wallets SET balance = '$newWalletBalance' WHERE user_id = '$userIdToEdit'";
        mysqli_query($connection, $updateUserWalletQuery);
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
</head>
<body>
    <h1>Admin Panel</h1>

    <h2>Benutzer</h2>
    <table border="1">
        <tr>
            <th>User ID</th>
            <th>Email</th>
            <th>Aktionen</th>
        </tr>
        <?php
            while ($userRow = mysqli_fetch_assoc($userResult)) {
                echo "<tr>
                        <td>{$userRow['user_id']}</td>
                        <td>{$userRow['email']}</td>
                        <td>
                            <form method='post'>
                                <input type='hidden' name='user_id' value='{$userRow['user_id']}'>
                                <button type='submit' name='delete_user'>Löschen</button>
                            </form>
                        </td>
                    </tr>";
            }
        ?>
    </table>

    <h2>Hauptwallet bearbeiten</h2>
    <form method="post">
        <label for="new_main_wallet_balance">Neues Guthaben für Hauptwallet:</label>
        <input type="text" name="new_main_wallet_balance" required>
        <button type="submit" name="edit_main_wallet">Aktualisieren</button>
    </form>

    <h2>Benutzer hinzufügen</h2>
    <form method="post">
        <label for="email">Email:</label>
        <input type="email" name="email" required>

        <label for="password">Passwort:</label>
        <input type="password" name="password" required>

        <button type="submit" name="add_user">Benutzer hinzufügen</button>
    </form>

    <h2>Wallet-Guthaben bearbeiten</h2>
    <form method="post">
        <label for="user_id">Benutzer auswählen:</label>
        <select name="user_id">
            <?php
                // Dropdown-Liste für Benutzer erstellen
                $userDropdownQuery = "SELECT * FROM users";
                $userDropdownResult = mysqli_query($connection, $userDropdownQuery);

                while ($userDropdownRow = mysqli_fetch_assoc($userDropdownResult)) {
                    echo "<option value='{$userDropdownRow['user_id']}'>{$userDropdownRow['email']}</option>";
                }
            ?>
        </select>

        <label for="new_wallet_balance">Neues Wallet-Guthaben:</label>
        <input type="text" name="new_wallet_balance" required>

        <button type="submit" name="edit_user_wallet">Aktualisieren</button>
    </form>
</body>
</html>
