<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}
$loggedInUser = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nice Finance - Menu</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
        }

        .navbar {
            background-color: #354798;
            padding: 10px;
            display: flex;
            justify-content: space-between;
        }

        .left-buttons, .right-buttons {
            display: flex;
            align-items: center;
        }

        .circle-button {
            width: 60px;
            height: 60px;
            margin: 5px;
            color: #fff;
            border: none;
            background-color: #354798;
            border-radius: 50%;
            cursor: pointer;
        }

        .circle-button:nth-child(2) {
            margin-left: 10px;
        }

        .circle-button:last-child {
            background-color: #fff;
            color: #000;
            font-family: Arial, sans-serif;
            font-size: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -10px;
            justify-content: center; /* Hier wird die Reihe horizontal zentriert */
        }

.col-4 {
    flex: 0 0 33.33%;
    max-width: 33.33%;
    
    padding: 0 10px;
    margin-top: 80px;
    margin-bottom: 20px;
    display: flex;
    justify-content: center;
}


        .col-4 img {
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="left-buttons">
            <button class="circle-button">+</button>
            <button onclick="location.href = 'abbuchen.php';" class="circle-button">-</button>
        </div>
        <div class="right-buttons">
            <button class="circle-button" id="usernameButton"></button>
        </div>
    </nav>
    <div class="container">
        <div class="row">
            <div class="col-4">
                <a href="Finanzen.php">
                    <img src="./assets/Finanzen.svg" class="img-fluid" alt="Finanzen">
                </a>
            </div>
            <div class="col-4">
                <a href="verkauf.php">
                    <img src="./assets/Verkauf.svg" class="img-fluid" alt="Verkauf">
                </a>
            </div>
            <div class="col-4">
                <img src="./assets/Kassa.svg" class="img-fluid" alt="Kassa">
            </div>
            <div class="col-4">
                <a href="./lager/index.php">
                    <img src="./assets/Lager.svg" class="img-fluid" alt="Lager">
                </a>
            </div>
            <div class="col-4">
                <img src="./assets/Statistik.svg" class="img-fluid" alt="Statistik">
            </div>
            <div class="col-4">
                <img src="./assets/Kunden.svg" class="img-fluid" alt="Kunden">
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var loggedInUser = "<?php echo $loggedInUser; ?>";
            var firstLetter = loggedInUser.charAt(0).toUpperCase();

            var usernameButton = document.getElementById("usernameButton");
            usernameButton.innerText = firstLetter;
        });
    </script>
</body>
</html>
