<?php
    // Inkludiere die Datei für die Datenbankverbindung
    include(__DIR__ . '/db_connection.php');

    // Session starten
    session_start();

    // Überprüfe, ob der Benutzer eingeloggt ist
    if (!isset($_SESSION['user_id'])) {
        // Wenn nicht eingeloggt, zur Login-Seite weiterleiten
        header('Location: login.php');
        exit();
    }

    // Hole den eingeloggten Benutzer
    $user_id = $_SESSION['user_id'];
    $query = "SELECT * FROM users WHERE user_id = $user_id";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $user = mysqli_fetch_assoc($result);
        $loggedInUser = $user['email']; // Hier entsprechend die korrekte Spalte auswählen, die den Benutzernamen enthält
    } else {
        // Falls Benutzer nicht gefunden wird, zur Login-Seite weiterleiten
        header('Location: login.php');
        exit();
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link rel="stylesheet" href="menu.css">
    <title>Nice Finance - Menu</title>
    <style>
        /* Füge diese Stile hinzu, um sicherzustellen, dass der Button wie die runden Buttons aussieht */
        .right-buttons .circle-button {
            background-color: #fff;
            color: #333;
            border: none;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            margin: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="left-buttons">
            <button style="color: #333; font-size: 20px; font-Family: Arial; "class="circle-button">+</button>
            <button onclick="" style="color: #333; font-size: 20px;" class="circle-button">-</button>
        </div>
        <div class="right-buttons">
            <button class="circle-button" id="usernameButton"></button>
        </div>
    </nav>
    <div style="height: 100vh; width:100%; display:flex; justify-content :center; align-items:center">
        <div class="container-fluid row">
            <div onclick="" class="col-6"> <a href="dashboard.php"> <img src="./assets/Finanzen.svg" class="img-fluid"></a></div>
            <div class="col-6" > <a href="verkauf.php"><img src="./assets//Verkauf.svg" class="img-fluid" alt="" srcset=""></a></div>
            <div class="col-6"><img src="./assets//Kassa.svg" class="img-fluid" alt="" srcset=""></div>
            <div class="col-6"> <a href="./lager//index.php">  <img src="./assets//Lager.svg" class="img-fluid" alt="" srcset=""></a></div>
            <div class="col-6"><img src="./assets//Statistik.svg" class="img-fluid" alt="" srcset=""></div>
            <div class="col-6"><img src="./assets//Kunden.svg" class="img-fluid" alt="" srcset=""></div>
        </div>
    </div>

    <script>
        // JavaScript code to set the first letter of the username on the button
        document.addEventListener("DOMContentLoaded", function () {
            // Assume you have a variable 'loggedInUser' that holds the username
            // Replace 'loggedInUser' with the actual variable or method to get the username
            var loggedInUser = "<?php echo $loggedInUser; ?>"; // Replace this with your actual variable or method

            // Get the first letter of the username
            var firstLetter = loggedInUser.charAt(0).toUpperCase();

            // Set the first letter on the button with black color and Arial font
            var usernameButton = document.getElementById("usernameButton");
            usernameButton.innerText = firstLetter;
            usernameButton.style.color = "#000"; // Set text color to black
            usernameButton.style.fontFamily = "Arial, sans-serif";
            usernameButton.style.fontSize = "20px"; // Set font to Arial
        });
    </script>
</body>
</html>