<?php
// Inkludiere die Datei für die Datenbankverbindung
include(__DIR__ . '/db_connection.php');

// Session starten
session_start();

// Überprüfe, ob der Benutzer angemeldet ist
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

// Holen Sie die Benutzerdaten aus der Datenbank
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM users WHERE user_id = '$user_id'";
$result = mysqli_query($connection, $query);

if ($result && mysqli_num_rows($result) > 0) {
    $user = mysqli_fetch_assoc($result);
    $username = $user['email']; // Hier musst du die tatsächliche Spalte für den Benutzernamen verwenden
} else {
    // Benutzerdaten nicht gefunden
    header('Location: index.php');
    exit();
}

// Holen Sie die Wallet-Informationen für den angemeldeten Benutzer
$userWalletQuery = "SELECT * FROM wallets WHERE user_id = '$user_id'";
$userWalletResult = mysqli_query($connection, $userWalletQuery);

if (!$userWalletResult) {
    die("Query fehlgeschlagen: " . mysqli_error($connection));
}

// Überprüfen Sie, ob ein gültiges Ergebnis vorhanden ist
if ($userWalletResult && mysqli_num_rows($userWalletResult) > 0) {
    // Wallet-Informationen für den angemeldeten Benutzer
    $userWallet = mysqli_fetch_assoc($userWalletResult);
    $userWalletBalance = $userWallet['balance'];
} else {
    die("Keine Daten für den Benutzer gefunden");
}

// Holen Sie die Wallet-Informationen für das Main Wallet
$mainWalletQuery = "SELECT * FROM main_wallet WHERE wallet_id = 1";
$mainWalletResult = mysqli_query($connection, $mainWalletQuery);

if (!$mainWalletResult) {
    die("Query fehlgeschlagen: " . mysqli_error($connection));
}

// Wallet-Informationen für das Main Wallet
$mainWallet = mysqli_fetch_assoc($mainWalletResult);

// Überprüfe, ob das Main Wallet-Array gültig ist
if ($mainWallet) {
    $mainWalletBalance = $mainWallet['balance'];
} else {
    die("Fehler beim Abrufen der Main Wallet-Informationen");
}

// Verarbeite das Abhebeformular
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $withdrawAmount = $_POST['withdraw_amount'];

    // Überprüfe, ob das Main Wallet ausreichend Guthaben hat
    if ($mainWalletBalance >= $withdrawAmount) {
        // Aktualisiere das Main Wallet-Guthaben
        $newMainWalletBalance = $mainWalletBalance - $withdrawAmount;
        $updateMainWalletQuery = "UPDATE main_wallet SET balance = '$newMainWalletBalance' WHERE wallet_id = 1";
        $updateMainWalletResult = mysqli_query($connection, $updateMainWalletQuery);

        if (!$updateMainWalletResult) {
            die("Query fehlgeschlagen: " . mysqli_error($connection));
        }

        // Füge einen Eintrag zur Transaktionshistorie hinzu
        $timestamp = date("Y-m-d H:i:s");
        $addTransactionQuery = "INSERT INTO transactions (sender_wallet_id, amount, timestamp) VALUES (1, '$withdrawAmount', '$timestamp')";
        $addTransactionResult = mysqli_query($connection, $addTransactionQuery);

        if (!$addTransactionResult) {
            die("Query fehlgeschlagen: " . mysqli_error($connection));
        }

        // Aktualisiere das Benutzer-Wallet-Guthaben
        $newUserWalletBalance = $userWalletBalance + $withdrawAmount;
        $updateUserWalletQuery = "UPDATE wallets SET balance = '$newUserWalletBalance' WHERE user_id = '$user_id'";
        $updateUserWalletResult = mysqli_query($connection, $updateUserWalletQuery);

        if (!$updateUserWalletResult) {
            die("Query fehlgeschlagen: " . mysqli_error($connection));
        }

        // Aktualisiere die Benutzer-Wallet-Informationen
        //$userWalletQuery = "SELECT * FROM wallets WHERE user_id = '$user_id'";
        $userWalletResult = mysqli_query($connection, $userWalletQuery);
        $userWallet = mysqli_fetch_assoc($userWalletResult);
        $userWalletBalance = $userWallet['balance'];
        
    } else {
        // Nicht genügend Guthaben im Main Wallet
        $withdrawError = "Nicht genügend Guthaben im Haupt-Wallet.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nice Finance - Dashboard</title>
    <style>
        /* CSS-Styling bleibt unverändert */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100vh;
        }

        .navbar {
            background-color: #354798;
            padding: 15px;
            width: 100%;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            z-index: 1000;
        }

        .navbar h1 {
            color: #fff;
            margin: 0;
            text-align: center;
        }

        .dashboard-container {
            width: 100%;
            margin-top: 80px;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
        }

        .card {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin: 20px;
            text-align: center;
            width: 90%;
            max-width: 400px;
        }

        .card h2 {
            color: #333;
        }

        .user-info p {
            margin: 5px 0;
        }

        .links-container {
            margin-top: 20px;
            display: flex;
            justify-content: space-around;
        }

        .links-container a {
            text-decoration: none;
            padding: 10px;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
        }

        .income-link {
            background-color: green;
        }

        .expense-link {
            background-color: red;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h1>Nice Finance</h1>
    </div>

    <div class="dashboard-container">
        <div class="card">
            <h2><?php echo $username; ?></h2>
            <div class="user-info">
                <p>Aktuelles Wallet-Guthaben: <?php echo ($userWalletBalance); ?></p>
            </div>
            
            <!-- Abhebeformular -->
            <form method="post" action="">
                <label for="withdraw_amount">Abheben:</label>
                <input type="text" name="withdraw_amount" id="withdraw_amount" placeholder="Betrag eingeben" required>
                <button type="submit">Abheben</button>
            </form>

            <?php
            if (isset($withdrawError)) {
                echo "<p style='color: red;'>$withdrawError</p>";
            }
            ?>
        </div>

        <div class="card">
            <h2>Transaktionshistorie</h2>
            <?php
            // Holen Sie die Transaktionshistorie für den angemeldeten Benutzer
            $transactionHistoryQuery = "SELECT * FROM transactions WHERE sender_wallet_id = '$user_id' ORDER BY timestamp DESC LIMIT 5";
            $transactionHistoryResult = mysqli_query($connection, $transactionHistoryQuery);

            if (!$transactionHistoryResult) {
                die("Query fehlgeschlagen: " . mysqli_error($connection));
            }

            while ($transaction = mysqli_fetch_assoc($transactionHistoryResult)) {
                $amount = $transaction['amount'];
                $timestamp = $transaction['timestamp'];

                if ($amount < 0) {
                    echo "<p style='color: red;'>$timestamp: Abgehoben - $amount</p>";
                } else {
                    echo "<p style='color: green;'>$timestamp: Eingezahlt - $amount</p>";
                }
            }
            ?>
        </div>

        <div class="card">
            <h2>Main Wallet</h2>
            <div class="user-info">
                <p>Aktuelles Guthaben: <?php echo $mainWalletBalance; ?></p>
            </div>
            <div class="links-container">
                <a href="#" class="income-link">Einnahmen</a>
                <a href="#" class="expense-link">Ausgaben</a>
            </div>
        </div>
    </div>

    <!-- Historie -->
    
</body>
</html>
