<?php
    // Inkludiere die Datei für die Datenbankverbindung
    include(__DIR__ . '/db_connection.php');

    // Session starten
    session_start();

    // Überprüfe die Anmeldeinformationen, wenn das Formular gesendet wurde
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $username = mysqli_real_escape_string($connection, $_POST['username']);
        $password = $_POST['password'];

        $query = "SELECT * FROM users WHERE email = '$username'";
        $result = mysqli_query($connection, $query);

        if ($result && mysqli_num_rows($result) > 0) {
            $user = mysqli_fetch_assoc($result);

            if (password_verify($password, $user['password'])) {
                // Authentifizierung erfolgreich
                $_SESSION['user_id'] = $user['user_id'];
                header('Location: menu.php'); // Hier kannst du zur Dashboard-Seite weiterleiten
                exit();
            } else {
                // Falsches Passwort
                $error_message = "Anmeldedaten stimmen nicht überein. Bitte versuche es erneut.";
            }
        } else {
            // Benutzer nicht gefunden
            $error_message = "Anmeldedaten stimmen nicht überein. Bitte versuche es erneut.";
        }
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nice Finance - Login</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100vh;
        }

        .navbar {
            background-color: #333;
            padding: 15px;
            width: 100%;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            z-index: 1000;
        }

        .navbar h1 {
            color: #fff;
            margin: 0;
        }

        .login-container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 300px;
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            margin-top: 80px;
        }

        .login-container h2 {
            color: #333;
        }

        .login-form {
            margin-top: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            color: #333;
        }

        .form-group input {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        .form-group button {
            background-color: #4caf50;
            color: #fff;
            padding: 10px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        .form-group button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h1>Nice Finance</h1>
    </div>

    <div class="login-container">
        <h2>Login</h2>
        
        <?php
            // Wenn ein Fehler aufgetreten ist, zeige die Fehlermeldung an
            if (isset($error_message)) {
                echo "<p style='color: red;'>$error_message</p>";
            }
        ?>

        <form class="login-form" action="" method="post">
            <div class="form-group">
                <label for="username">Benutzername:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Passwort:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="form-group">
                <button type="submit">Anmelden</button>
            </div>
        </form>
    </div>
</body>
</html>
