<?php
// Inkludiere die Datei für die Datenbankverbindung
include(__DIR__ . '/db_connection.php');

// Session starten
session_start();

// Überprüfe, ob der Benutzer angemeldet ist
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

// Holen Sie die Benutzerdaten aus der Datenbank
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM users WHERE user_id = '$user_id'";
$result = mysqli_query($connection, $query);

if ($result && mysqli_num_rows($result) > 0) {
    $user = mysqli_fetch_assoc($result);
    $username = $user['email']; // Hier musst du die tatsächliche Spalte für den Benutzernamen verwenden
} else {
    // Benutzerdaten nicht gefunden
    header('Location: index.php');
    exit();
}

// Holen Sie die Transaktionshistorie für den angemeldeten Benutzer
$transactionHistoryQuery = "SELECT * FROM transactions WHERE sender_wallet_id = '$user_id' ORDER BY timestamp DESC";
$transactionHistoryResult = mysqli_query($connection, $transactionHistoryQuery);

if (!$transactionHistoryResult) {
    die("Query fehlgeschlagen: " . mysqli_error($connection));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nice Finance - Transaktionshistorie</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100vh;
        }

        .navbar {
            background-color: #354798;
            padding: 15px;
            width: 100%;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            z-index: 1000;
        }

        .navbar h1 {
            color: #fff;
            margin: 0;
            text-align: center;
        }

        .transaction-history {
            width: 100%;
            margin-top: 80px;
            text-align: center;
        }

        .transaction-entry {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin: 20px;
            width: 90%;
            max-width: 400px;
        }

        .transaction-entry p {
            margin: 5px 0;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h1>Nice Finance - Transaktionshistorie</h1>
    </div>

    <div class="transaction-history">
        <?php
        while ($transaction = mysqli_fetch_assoc($transactionHistoryResult)) {
            $amount = $transaction['amount'];
            $timestamp = $transaction['timestamp'];

            if ($amount < 0) {
                echo "<div class='transaction-entry' style='color: red;'>";
                echo "<p>$timestamp: Abgehoben - " . abs($amount) . "</p>";
                echo "</div>";
            } else {
                echo "<div class='transaction-entry' style='color: green;'>";
                echo "<p>$timestamp: Einzahlung - $amount</p>";
                echo "</div>";
            }
        }
        ?>
    </div>
</body>
</html>
